/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.util;

import java.util.UUID;

public class StackListEntry<T> {
    private UUID id;
    private T stack;
    private long count;
    private Unmodifiable<T> unmodifiableView;

    public StackListEntry(T stack, long count) {
        this.stack = stack;
        this.id = UUID.randomUUID();
        this.count = count;
        this.unmodifiableView = new Unmodifiable(this);
    }

    public StackListEntry(UUID id, T stack, long count) {
        this.id = id;
        this.stack = stack;
        this.count = count;
        this.unmodifiableView = new Unmodifiable(this);
    }

    private StackListEntry() {
    }

    public UUID getId() {
        return this.id;
    }

    public T getStack() {
        return this.stack;
    }

    public long getCount() {
        return this.count;
    }

    public Unmodifiable<T> asUnmodifiable() {
        return this.unmodifiableView;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void grow(long count) {
        this.count += count;
    }

    public void shrink(long count) {
        this.count -= count;
    }

    private static class Unmodifiable<T>
    extends StackListEntry<T> {
        private final StackListEntry<T> delegate;

        private Unmodifiable(StackListEntry<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T getStack() {
            return this.delegate.getStack();
        }

        @Override
        public UUID getId() {
            return this.delegate.getId();
        }

        @Override
        public long getCount() {
            return ((StackListEntry)this.delegate).count;
        }

        @Override
        public void setCount(long count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void grow(long count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shrink(long count) {
            throw new UnsupportedOperationException();
        }
    }
}

